#version 330
#extension GL_EXT_gpu_shader4 : enable
//Haru86_polar coordinateMod01.fsh  by   Haru86
//https://www.shadertoy.com/view/3lVczD
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

#define time iTime
float PI = 3.1415926535;
float bpm = 108.0;


mat2 rot(float r){
  return mat2(cos(r),sin(r),-sin(r),cos(r));
}

float cube(vec3 p, vec3 s){
  vec3 q = abs(p);
  vec3 m = max(s-q,0.0);
  return length(max(q-s,0.0))-min(min(m.x,m.y),m.z);
}

float Sphere(vec3 p,float s)
{
    return length(p)-s;
}

float map(vec3 p){
  
  float ad=1.0;
  float a=atan(p.x,p.z);
  float l=log(length(p.xz));
  
  
  
  //pos1
  vec3 pos1=p;
  pos1.xz=vec2(l,a-iTime);
  pos1.xz*=5.0;
  pos1.x+=iTime*2.0;
  //pos1.y+=max(l*3.0,0.0);
  pos1.y+=sin(3.0*iTime+l*10.0)*l;
  //pos1.y=max(pos1.y,0.0);
  
  //pos2
  vec3 pos2=p;
  pos2.xz=vec2(l,a-iTime*2.0);
  pos2.xz*=5.0;
   //pos2.y+=l*3.0;
  pos2.y+=max(l*3.0,0.0);
  pos2.x+=2.0*iTime;
  
  
  float k = 0.75;
  pos1.xz= mod(pos1.xz,k)-0.5*k;
  float k2=5.0;
  pos2.xz=mod(pos2.xz,k2)-k2*0.5;
 
  float d = cube(pos1,float(1.0)*vec3(0.5,0.5,0.5)*0.5);
  float d2=Sphere(pos2+vec3(0.0,0.5,0.0),0.5);
  
  
  return d;
 // return min(d,d2);
}

vec3 gn(vec3 p)
{
    vec2 e=vec2(0.001,0.0);
    return normalize(vec3(map(p+e.xyy)-map(p-e.xyy),
                map(p+e.yxy)-map(p-e.yxy),
                map(p+e.yyx)-map(p-e.yyx)));
}

void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    vec2 uv=(gl_FragCoord.xy*2.0-iResolution.xy)/min(iResolution.x,iResolution.y);
    vec3 col=vec3(0.);
    
    vec3 ro=vec3(0.0,-24.0-sin(iTime)*8.0,16.0);
    vec3 ta=vec3(0.0,0.0,0.0);
    //vec3 ro=vec3(cos(iTime*0.5)*10.0,-8.0,10.0*sin(iTime*0.5));
    
    vec3 cDir=normalize(ta-ro);
    vec3 cSide=(cross(cDir,vec3(0.0,1.0,0.0)));
    vec3 cUp=(cross(cDir,cSide));
    float depth=2.0;
    vec3 rd=normalize(vec3(uv.x*cSide+uv.y*cUp+depth*cDir));
    
    float d,t=0.0;
    float tsr;
    vec3 ac = vec3(0.0);

    float ad=1.0;
    for(int i = 0;i<66;i++){
      d = map(ro+rd*t);
     
      t += d*0.5;
      ac += exp(-d*12.);
      if(d<0.0001||t>1000.0)break;
    }
    
    vec3 sd=ro+rd*t;
    vec3 normal=gn(sd);
    ro=sd;
    rd=reflect(rd,normal);
    t=0.1;
    float acc2=0.0;
    
    for(int i=0;i<33;i++)
    {
         d=map(ro+rd*t);
         if(d<0.001)break;
         t+=d*0.5;
         acc2+=exp(-3.0*d);
    }
    
  

    col = 0.06*ac*vec3(0.2,1.0,1.0);
    col+=0.03*acc2*vec3(0.0,0.0,1.0);
   

    gl_FragColor=vec4(col,1.);
}